// from ALLEGRO  By Shawn Hargreaves
// Optimised by Cloud Wu and Burton Radons.

#include "constant.h"

#pragma off( check_stack )
// 16 and 15 bits color mode alpha blender 

/* macro for constructing the blender routines */
#define BLEND16(n)                                                             \
									     \
   static unsigned long blend16_##n(unsigned long x, unsigned long y)        \
   {                                                                         \
      unsigned long result;                                                  \
									     \
      x = ((x&0xFFFF) | (x<<16)) & 0x7E0F81F;                                \
      y = ((y&0xFFFF) | (y<<16)) & 0x7E0F81F;                                \
									     \
      result = ((x - y) * (n*32/31) / 32 + y) & 0x7E0F81F;                   \
									     \
      return ((result&0xFFFF) | (result>>16));                               \
   }

BLEND16(0)   BLEND16(1)   BLEND16(2)   BLEND16(3) 
BLEND16(4)   BLEND16(5)   BLEND16(6)   BLEND16(7) 
BLEND16(8)   BLEND16(9)   BLEND16(10)  BLEND16(11) 
BLEND16(12)  BLEND16(13)  BLEND16(14)  BLEND16(15) 
BLEND16(16)  BLEND16(17)  BLEND16(18)  BLEND16(19) 
BLEND16(20)  BLEND16(21)  BLEND16(22)  BLEND16(23) 
BLEND16(24)  BLEND16(25)  BLEND16(26)  BLEND16(27) 
BLEND16(28)  BLEND16(29)  BLEND16(30)  BLEND16(31) 

BlenderMap transBlender16 = 
{ {
   blend16_0,  blend16_0,  blend16_0,  blend16_0,
   blend16_0,  blend16_0,  blend16_0,  blend16_0,
   blend16_1,  blend16_1,  blend16_1,  blend16_1,
   blend16_1,  blend16_1,  blend16_1,  blend16_1,
   blend16_2,  blend16_2,  blend16_2,  blend16_2,
   blend16_2,  blend16_2,  blend16_2,  blend16_2,
   blend16_3,  blend16_3,  blend16_3,  blend16_3,
   blend16_3,  blend16_3,  blend16_3,  blend16_3,
   blend16_4,  blend16_4,  blend16_4,  blend16_4,
   blend16_4,  blend16_4,  blend16_4,  blend16_4,
   blend16_5,  blend16_5,  blend16_5,  blend16_5,
   blend16_5,  blend16_5,  blend16_5,  blend16_5,
   blend16_6,  blend16_6,  blend16_6,  blend16_6,
   blend16_6,  blend16_6,  blend16_6,  blend16_6,
   blend16_7,  blend16_7,  blend16_7,  blend16_7,
   blend16_7,  blend16_7,  blend16_7,  blend16_7,
   blend16_8,  blend16_8,  blend16_8,  blend16_8,
   blend16_8,  blend16_8,  blend16_8,  blend16_8,
   blend16_9,  blend16_9,  blend16_9,  blend16_9,
   blend16_9,  blend16_9,  blend16_9,  blend16_9,
   blend16_10, blend16_10, blend16_10, blend16_10,
   blend16_10, blend16_10, blend16_10, blend16_10,
   blend16_11, blend16_11, blend16_11, blend16_11,
   blend16_11, blend16_11, blend16_11, blend16_11,
   blend16_12, blend16_12, blend16_12, blend16_12,
   blend16_12, blend16_12, blend16_12, blend16_12,
   blend16_13, blend16_13, blend16_13, blend16_13,
   blend16_13, blend16_13, blend16_13, blend16_13,
   blend16_14, blend16_14, blend16_14, blend16_14,
   blend16_14, blend16_14, blend16_14, blend16_14,
   blend16_15, blend16_15, blend16_15, blend16_15,
   blend16_15, blend16_15, blend16_15, blend16_15,
   blend16_16, blend16_16, blend16_16, blend16_16,
   blend16_16, blend16_16, blend16_16, blend16_16,
   blend16_17, blend16_17, blend16_17, blend16_17,
   blend16_17, blend16_17, blend16_17, blend16_17,
   blend16_18, blend16_18, blend16_18, blend16_18,
   blend16_18, blend16_18, blend16_18, blend16_18,
   blend16_19, blend16_19, blend16_19, blend16_19,
   blend16_19, blend16_19, blend16_19, blend16_19,
   blend16_20, blend16_20, blend16_20, blend16_20,
   blend16_20, blend16_20, blend16_20, blend16_20,
   blend16_21, blend16_21, blend16_21, blend16_21,
   blend16_21, blend16_21, blend16_21, blend16_21,
   blend16_22, blend16_22, blend16_22, blend16_22,
   blend16_22, blend16_22, blend16_22, blend16_22,
   blend16_23, blend16_23, blend16_23, blend16_23,
   blend16_23, blend16_23, blend16_23, blend16_23,
   blend16_24, blend16_24, blend16_24, blend16_24,
   blend16_24, blend16_24, blend16_24, blend16_24,
   blend16_25, blend16_25, blend16_25, blend16_25,
   blend16_25, blend16_25, blend16_25, blend16_25,
   blend16_26, blend16_26, blend16_26, blend16_26,
   blend16_26, blend16_26, blend16_26, blend16_26,
   blend16_27, blend16_27, blend16_27, blend16_27,
   blend16_27, blend16_27, blend16_27, blend16_27,
   blend16_28, blend16_28, blend16_28, blend16_28,
   blend16_28, blend16_28, blend16_28, blend16_28,
   blend16_29, blend16_29, blend16_29, blend16_29,
   blend16_29, blend16_29, blend16_29, blend16_29,
   blend16_30, blend16_30, blend16_30, blend16_30,
   blend16_30, blend16_30, blend16_30, blend16_30,
   blend16_31, blend16_31, blend16_31, blend16_31,
   blend16_31, blend16_31, blend16_31, blend16_31,
} };

///////////////////////////////////////////////////////////////////////////////////////////////
/* macro for constructing the blender routines */
#define BLEND15(n)                                                             \
									     \
   static unsigned long blend15_##n(unsigned long x, unsigned long y)        \
   {                                                                         \
      unsigned long result;                                                  \
									     \
      x = ((x&0xFFFF) | (x<<16)) & 0x3E07C1F;                                \
      y = ((y&0xFFFF) | (y<<16)) & 0x3E07C1F;                                \
									     \
      result = ((x - y) * (n*32/31) / 32 + y) & 0x3E07C1F;                   \
									     \
      return ((result&0xFFFF) | (result>>16));                               \
   }



/* declare 32 interpolation functions (one for each alpha) */ 
BLEND15(0)   BLEND15(1)   BLEND15(2)   BLEND15(3) 
BLEND15(4)   BLEND15(5)   BLEND15(6)   BLEND15(7) 
BLEND15(8)   BLEND15(9)   BLEND15(10)  BLEND15(11) 
BLEND15(12)  BLEND15(13)  BLEND15(14)  BLEND15(15) 
BLEND15(16)  BLEND15(17)  BLEND15(18)  BLEND15(19) 
BLEND15(20)  BLEND15(21)  BLEND15(22)  BLEND15(23) 
BLEND15(24)  BLEND15(25)  BLEND15(26)  BLEND15(27) 
BLEND15(28)  BLEND15(29)  BLEND15(30)  BLEND15(31) 



/* and list them all in a table */ 
BlenderMap transBlender15 = 
{ {
   blend15_0,  blend15_0,  blend15_0,  blend15_0,
   blend15_0,  blend15_0,  blend15_0,  blend15_0,
   blend15_1,  blend15_1,  blend15_1,  blend15_1,
   blend15_1,  blend15_1,  blend15_1,  blend15_1,
   blend15_2,  blend15_2,  blend15_2,  blend15_2,
   blend15_2,  blend15_2,  blend15_2,  blend15_2,
   blend15_3,  blend15_3,  blend15_3,  blend15_3,
   blend15_3,  blend15_3,  blend15_3,  blend15_3,
   blend15_4,  blend15_4,  blend15_4,  blend15_4,
   blend15_4,  blend15_4,  blend15_4,  blend15_4,
   blend15_5,  blend15_5,  blend15_5,  blend15_5,
   blend15_5,  blend15_5,  blend15_5,  blend15_5,
   blend15_6,  blend15_6,  blend15_6,  blend15_6,
   blend15_6,  blend15_6,  blend15_6,  blend15_6,
   blend15_7,  blend15_7,  blend15_7,  blend15_7,
   blend15_7,  blend15_7,  blend15_7,  blend15_7,
   blend15_8,  blend15_8,  blend15_8,  blend15_8,
   blend15_8,  blend15_8,  blend15_8,  blend15_8,
   blend15_9,  blend15_9,  blend15_9,  blend15_9,
   blend15_9,  blend15_9,  blend15_9,  blend15_9,
   blend15_10, blend15_10, blend15_10, blend15_10,
   blend15_10, blend15_10, blend15_10, blend15_10,
   blend15_11, blend15_11, blend15_11, blend15_11,
   blend15_11, blend15_11, blend15_11, blend15_11,
   blend15_12, blend15_12, blend15_12, blend15_12,
   blend15_12, blend15_12, blend15_12, blend15_12,
   blend15_13, blend15_13, blend15_13, blend15_13,
   blend15_13, blend15_13, blend15_13, blend15_13,
   blend15_14, blend15_14, blend15_14, blend15_14,
   blend15_14, blend15_14, blend15_14, blend15_14,
   blend15_15, blend15_15, blend15_15, blend15_15,
   blend15_15, blend15_15, blend15_15, blend15_15,
   blend15_16, blend15_16, blend15_16, blend15_16,
   blend15_16, blend15_16, blend15_16, blend15_16,
   blend15_17, blend15_17, blend15_17, blend15_17,
   blend15_17, blend15_17, blend15_17, blend15_17,
   blend15_18, blend15_18, blend15_18, blend15_18,
   blend15_18, blend15_18, blend15_18, blend15_18,
   blend15_19, blend15_19, blend15_19, blend15_19,
   blend15_19, blend15_19, blend15_19, blend15_19,
   blend15_20, blend15_20, blend15_20, blend15_20,
   blend15_20, blend15_20, blend15_20, blend15_20,
   blend15_21, blend15_21, blend15_21, blend15_21,
   blend15_21, blend15_21, blend15_21, blend15_21,
   blend15_22, blend15_22, blend15_22, blend15_22,
   blend15_22, blend15_22, blend15_22, blend15_22,
   blend15_23, blend15_23, blend15_23, blend15_23,
   blend15_23, blend15_23, blend15_23, blend15_23,
   blend15_24, blend15_24, blend15_24, blend15_24,
   blend15_24, blend15_24, blend15_24, blend15_24,
   blend15_25, blend15_25, blend15_25, blend15_25,
   blend15_25, blend15_25, blend15_25, blend15_25,
   blend15_26, blend15_26, blend15_26, blend15_26,
   blend15_26, blend15_26, blend15_26, blend15_26,
   blend15_27, blend15_27, blend15_27, blend15_27,
   blend15_27, blend15_27, blend15_27, blend15_27,
   blend15_28, blend15_28, blend15_28, blend15_28,
   blend15_28, blend15_28, blend15_28, blend15_28,
   blend15_29, blend15_29, blend15_29, blend15_29,
   blend15_29, blend15_29, blend15_29, blend15_29,
   blend15_30, blend15_30, blend15_30, blend15_30,
   blend15_30, blend15_30, blend15_30, blend15_30,
   blend15_31, blend15_31, blend15_31, blend15_31,
   blend15_31, blend15_31, blend15_31, blend15_31,
} };


#define BRIGHTNESS16( n ) 	\
							\
	static unsigned long brightness16_##n( unsigned long a )	\
	{															\
		unsigned long result;												\
		result = ((((a&0xffff) | (a<<16)) & 0x7e0f81f ) * n / 32 ) & 0x7e0f81f;	\
		return ( result | ( result >> 16 ));					\
	}

BRIGHTNESS16( 3 )	 BRIGHTNESS16( 5 )
BRIGHTNESS16( 6 )	 BRIGHTNESS16( 7 )	 BRIGHTNESS16( 9 )
BRIGHTNESS16( 10 )	BRIGHTNESS16( 11 )
BRIGHTNESS16( 13 )	BRIGHTNESS16( 14 )	BRIGHTNESS16( 15 )
BRIGHTNESS16( 17 )	BRIGHTNESS16( 18 )	BRIGHTNESS16( 19 )
BRIGHTNESS16( 21 )	BRIGHTNESS16( 22 )
BRIGHTNESS16( 23 )	BRIGHTNESS16( 25 )	BRIGHTNESS16( 26 )
BRIGHTNESS16( 27 )	BRIGHTNESS16( 28 )	BRIGHTNESS16( 29 )
BRIGHTNESS16( 30 )	BRIGHTNESS16( 31 )

static unsigned long brightness16_0( unsigned long a )
{
	return 0;
}

static unsigned long brightness16_1( unsigned long a )
{
	return 0;
}

static unsigned long brightness16_2( unsigned long a )
{
	return ( a >> 4 ) & 0x0861;
}

static unsigned long brightness16_4( unsigned long a )
{
	return ( a >> 3 ) & 0x18e3;
}

static unsigned long brightness16_8( unsigned long a )
{
	return ( a >> 2 ) & 0x39e7 ;
}

static unsigned long brightness16_12( unsigned long a )
{
	return ( a >> 3 ) & 0x18e3 + ( a >> 2 ) & 0x39e7;
}

static unsigned long brightness16_16( unsigned long a )
{
	return ( a >> 1 ) & 0x7bef;
}

static unsigned long brightness16_20( unsigned long a )
{
	return ( a >> 3 ) & 0x18e3 + ( a >> 1 ) & 0x7bef;
}

static unsigned long brightness16_24( unsigned long a )
{
	return (( a >> 1 ) & 0x7b1f ) + (( a >> 2 ) & 0x39e7 );
}

BrighterMap brighter16 = {
	{
   brightness16_0,  brightness16_0,  brightness16_0,  brightness16_0,
   brightness16_0,  brightness16_0,  brightness16_0,  brightness16_0,
   brightness16_1,  brightness16_1,  brightness16_1,  brightness16_1,
   brightness16_1,  brightness16_1,  brightness16_1,  brightness16_1,
   brightness16_2,  brightness16_2,  brightness16_2,  brightness16_2,
   brightness16_2,  brightness16_2,  brightness16_2,  brightness16_2,
   brightness16_3,  brightness16_3,  brightness16_3,  brightness16_3,
   brightness16_3,  brightness16_3,  brightness16_3,  brightness16_3,
   brightness16_4,  brightness16_4,  brightness16_4,  brightness16_4,
   brightness16_4,  brightness16_4,  brightness16_4,  brightness16_4,
   brightness16_5,  brightness16_5,  brightness16_5,  brightness16_5,
   brightness16_5,  brightness16_5,  brightness16_5,  brightness16_5,
   brightness16_6,  brightness16_6,  brightness16_6,  brightness16_6,
   brightness16_6,  brightness16_6,  brightness16_6,  brightness16_6,
   brightness16_7,  brightness16_7,  brightness16_7,  brightness16_7,
   brightness16_7,  brightness16_7,  brightness16_7,  brightness16_7,
   brightness16_8,  brightness16_8,  brightness16_8,  brightness16_8,
   brightness16_8,  brightness16_8,  brightness16_8,  brightness16_8,
   brightness16_9,  brightness16_9,  brightness16_9,  brightness16_9,
   brightness16_9,  brightness16_9,  brightness16_9,  brightness16_9,
   brightness16_10, brightness16_10, brightness16_10, brightness16_10,
   brightness16_10, brightness16_10, brightness16_10, brightness16_10,
   brightness16_11, brightness16_11, brightness16_11, brightness16_11,
   brightness16_11, brightness16_11, brightness16_11, brightness16_11,
   brightness16_12, brightness16_12, brightness16_12, brightness16_12,
   brightness16_12, brightness16_12, brightness16_12, brightness16_12,
   brightness16_13, brightness16_13, brightness16_13, brightness16_13,
   brightness16_13, brightness16_13, brightness16_13, brightness16_13,
   brightness16_14, brightness16_14, brightness16_14, brightness16_14,
   brightness16_14, brightness16_14, brightness16_14, brightness16_14,
   brightness16_15, brightness16_15, brightness16_15, brightness16_15,
   brightness16_15, brightness16_15, brightness16_15, brightness16_15,
   brightness16_16, brightness16_16, brightness16_16, brightness16_16,
   brightness16_16, brightness16_16, brightness16_16, brightness16_16,
   brightness16_17, brightness16_17, brightness16_17, brightness16_17,
   brightness16_17, brightness16_17, brightness16_17, brightness16_17,
   brightness16_18, brightness16_18, brightness16_18, brightness16_18,
   brightness16_18, brightness16_18, brightness16_18, brightness16_18,
   brightness16_19, brightness16_19, brightness16_19, brightness16_19,
   brightness16_19, brightness16_19, brightness16_19, brightness16_19,
   brightness16_20, brightness16_20, brightness16_20, brightness16_20,
   brightness16_20, brightness16_20, brightness16_20, brightness16_20,
   brightness16_21, brightness16_21, brightness16_21, brightness16_21,
   brightness16_21, brightness16_21, brightness16_21, brightness16_21,
   brightness16_22, brightness16_22, brightness16_22, brightness16_22,
   brightness16_22, brightness16_22, brightness16_22, brightness16_22,
   brightness16_23, brightness16_23, brightness16_23, brightness16_23,
   brightness16_23, brightness16_23, brightness16_23, brightness16_23,
   brightness16_24, brightness16_24, brightness16_24, brightness16_24,
   brightness16_24, brightness16_24, brightness16_24, brightness16_24,
   brightness16_25, brightness16_25, brightness16_25, brightness16_25,
   brightness16_25, brightness16_25, brightness16_25, brightness16_25,
   brightness16_26, brightness16_26, brightness16_26, brightness16_26,
   brightness16_26, brightness16_26, brightness16_26, brightness16_26,
   brightness16_27, brightness16_27, brightness16_27, brightness16_27,
   brightness16_27, brightness16_27, brightness16_27, brightness16_27,
   brightness16_28, brightness16_28, brightness16_28, brightness16_28,
   brightness16_28, brightness16_28, brightness16_28, brightness16_28,
   brightness16_29, brightness16_29, brightness16_29, brightness16_29,
   brightness16_29, brightness16_29, brightness16_29, brightness16_29,
   brightness16_30, brightness16_30, brightness16_30, brightness16_30,
   brightness16_30, brightness16_30, brightness16_30, brightness16_30,
   brightness16_31, brightness16_31, brightness16_31, brightness16_31,
   brightness16_31, brightness16_31, brightness16_31, brightness16_31,
	}
};


#define BRIGHTNESS15( n ) 	\
							\
	static unsigned long brightness15_##n( unsigned long a )	\
	{															\
		unsigned long result;												\
		result = ((((a&0xffff) | (a<<16)) & 0x3E07C1F ) * n / 32 ) & 0x3E07C1F;	\
		return ( result | ( result >> 16 ));					\
	}

BRIGHTNESS15( 3 )	 BRIGHTNESS15( 5 )
BRIGHTNESS15( 7 )	 BRIGHTNESS15( 9 )
BRIGHTNESS15( 10 )	BRIGHTNESS15( 11 )
BRIGHTNESS15( 13 )	BRIGHTNESS15( 14 )	BRIGHTNESS15( 15 )
BRIGHTNESS15( 17 )	BRIGHTNESS15( 18 )	BRIGHTNESS15( 19 )
BRIGHTNESS15( 21 )	BRIGHTNESS15( 22 )
BRIGHTNESS15( 23 )	BRIGHTNESS15( 25 )	BRIGHTNESS15( 26 )
BRIGHTNESS15( 27 )	BRIGHTNESS15( 29 )
BRIGHTNESS15( 30 )	BRIGHTNESS15( 31 )

static unsigned long brightness15_0( unsigned long a )
{
	return 0;
}

static unsigned long brightness15_1( unsigned long a )
{
	return 0;
}

static unsigned long brightness15_2( unsigned long a )
{
	return ( a >> 4 ) & 0x04210421;
}

static unsigned long brightness15_4( unsigned long a )
{
	return ( a >> 3 ) & 0x0c630c63;
}

static unsigned long brightness15_6( unsigned long a )
{
	return ( a >> 4 ) & 0x04210421 + ( a >> 3 ) & 0x0c630c63;
}

static unsigned long brightness15_8( unsigned long a )
{
	return ( a >> 2 ) & 0x1ce71ce7 ;
}

static unsigned long brightness15_12( unsigned long a )
{
	return ( a >> 3 ) & 0x0c630c63 + ( a >> 2 ) & 0x1ce71ce7;
}

static unsigned long brightness15_16( unsigned long a )
{
	return ( a >> 1 ) & 0x3def3def;
}

static unsigned long brightness15_20( unsigned long a )
{
	return ( a >> 3 ) & 0x0c630c63 + ( a >> 1 ) & 0x3def3def;
}

static unsigned long brightness15_24( unsigned long a )
{
	return (( a >> 1 ) & 0x3def3def ) + (( a >> 2 ) & 0x1ce71ce7 );
}

static unsigned long brightness15_28( unsigned long a )
{
	return (( a >> 1 ) & 0x3def3def ) + (( a >> 2 ) & 0x1ce71ce7 ) + (( a >> 3 ) & 0x0c630c63 );
}

BrighterMap brighter15 = {
	{
   brightness15_0,  brightness15_0,  brightness15_0,  brightness15_0,
   brightness15_0,  brightness15_0,  brightness15_0,  brightness15_0,
   brightness15_1,  brightness15_1,  brightness15_1,  brightness15_1,
   brightness15_1,  brightness15_1,  brightness15_1,  brightness15_1,
   brightness15_2,  brightness15_2,  brightness15_2,  brightness15_2,
   brightness15_2,  brightness15_2,  brightness15_2,  brightness15_2,
   brightness15_3,  brightness15_3,  brightness15_3,  brightness15_3,
   brightness15_3,  brightness15_3,  brightness15_3,  brightness15_3,
   brightness15_4,  brightness15_4,  brightness15_4,  brightness15_4,
   brightness15_4,  brightness15_4,  brightness15_4,  brightness15_4,
   brightness15_5,  brightness15_5,  brightness15_5,  brightness15_5,
   brightness15_5,  brightness15_5,  brightness15_5,  brightness15_5,
   brightness15_6,  brightness15_6,  brightness15_6,  brightness15_6,
   brightness15_6,  brightness15_6,  brightness15_6,  brightness15_6,
   brightness15_7,  brightness15_7,  brightness15_7,  brightness15_7,
   brightness15_7,  brightness15_7,  brightness15_7,  brightness15_7,
   brightness15_8,  brightness15_8,  brightness15_8,  brightness15_8,
   brightness15_8,  brightness15_8,  brightness15_8,  brightness15_8,
   brightness15_9,  brightness15_9,  brightness15_9,  brightness15_9,
   brightness15_9,  brightness15_9,  brightness15_9,  brightness15_9,
   brightness15_10, brightness15_10, brightness15_10, brightness15_10,
   brightness15_10, brightness15_10, brightness15_10, brightness15_10,
   brightness15_11, brightness15_11, brightness15_11, brightness15_11,
   brightness15_11, brightness15_11, brightness15_11, brightness15_11,
   brightness15_12, brightness15_12, brightness15_12, brightness15_12,
   brightness15_12, brightness15_12, brightness15_12, brightness15_12,
   brightness15_13, brightness15_13, brightness15_13, brightness15_13,
   brightness15_13, brightness15_13, brightness15_13, brightness15_13,
   brightness15_14, brightness15_14, brightness15_14, brightness15_14,
   brightness15_14, brightness15_14, brightness15_14, brightness15_14,
   brightness15_15, brightness15_15, brightness15_15, brightness15_15,
   brightness15_15, brightness15_15, brightness15_15, brightness15_15,
   brightness15_16, brightness15_16, brightness15_16, brightness15_16,
   brightness15_16, brightness15_16, brightness15_16, brightness15_16,
   brightness15_17, brightness15_17, brightness15_17, brightness15_17,
   brightness15_17, brightness15_17, brightness15_17, brightness15_17,
   brightness15_18, brightness15_18, brightness15_18, brightness15_18,
   brightness15_18, brightness15_18, brightness15_18, brightness15_18,
   brightness15_19, brightness15_19, brightness15_19, brightness15_19,
   brightness15_19, brightness15_19, brightness15_19, brightness15_19,
   brightness15_20, brightness15_20, brightness15_20, brightness15_20,
   brightness15_20, brightness15_20, brightness15_20, brightness15_20,
   brightness15_21, brightness15_21, brightness15_21, brightness15_21,
   brightness15_21, brightness15_21, brightness15_21, brightness15_21,
   brightness15_22, brightness15_22, brightness15_22, brightness15_22,
   brightness15_22, brightness15_22, brightness15_22, brightness15_22,
   brightness15_23, brightness15_23, brightness15_23, brightness15_23,
   brightness15_23, brightness15_23, brightness15_23, brightness15_23,
   brightness15_24, brightness15_24, brightness15_24, brightness15_24,
   brightness15_24, brightness15_24, brightness15_24, brightness15_24,
   brightness15_25, brightness15_25, brightness15_25, brightness15_25,
   brightness15_25, brightness15_25, brightness15_25, brightness15_25,
   brightness15_26, brightness15_26, brightness15_26, brightness15_26,
   brightness15_26, brightness15_26, brightness15_26, brightness15_26,
   brightness15_27, brightness15_27, brightness15_27, brightness15_27,
   brightness15_27, brightness15_27, brightness15_27, brightness15_27,
   brightness15_28, brightness15_28, brightness15_28, brightness15_28,
   brightness15_28, brightness15_28, brightness15_28, brightness15_28,
   brightness15_29, brightness15_29, brightness15_29, brightness15_29,
   brightness15_29, brightness15_29, brightness15_29, brightness15_29,
   brightness15_30, brightness15_30, brightness15_30, brightness15_30,
   brightness15_30, brightness15_30, brightness15_30, brightness15_30,
   brightness15_31, brightness15_31, brightness15_31, brightness15_31,
   brightness15_31, brightness15_31, brightness15_31, brightness15_31,
	}
};

#pragma on( check_stack )
